/*------------------------------------------------------------------------------*
 * File Name: INIFileEx.h														*
 * Creation: Folger 07/06/07													*
 * Purpose: Origin C Header														*
 * Copyright (c) OriginLab Corp.2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * Sim 03-11-2008 QA80-11240 INI_FILE_SUPPORT_READ_WRITE_DOUBLE					*
 *------------------------------------------------------------------------------*/
 
#ifndef __INIFILEEX_H__
#define __INIFILEEX_H__

#include <Settings.h>
#include <Array.h>
#define INI_FILE_NUM 2
enum
{
	USER_INI,
	SYSTEM_INI,
};

class INIFileEx
{
public:
	
	INIFileEx(LPCSTR lpcszFilename = NULL)
	{
		m_arrINIFile.SetAsOwner(true);
		m_strINIFile = lpcszFilename;
		
		for (int nINIType=0; nINIType<INI_FILE_NUM; nINIType++)
		{
			INIFile *pINIFile = NULL;
			string strFile;
			
			if (nINIType == USER_INI)
			{
				strFile = GetAppPath(false) + lpcszFilename;
				if (strFile.IsFile())
					pINIFile = new INIFile(lpcszFilename, true)
			}
			else if (nINIType == SYSTEM_INI)
			{
				strFile = GetAppPath(true) + lpcszFilename;
				if (strFile.IsFile())
					pINIFile = new INIFile(lpcszFilename, false);
			}
			
			if (pINIFile != NULL)
				m_arrINIFile.Add(*pINIFile);
		}
	}
	
	int ReadInt(LPCSTR lpcszSection, LPCSTR lpcszKey,int nDefault = -1)///Jake 10/07/07 SET_DEFAULT_VALUE_FOR_READING_INT
	{
		int nValue = -1;
		int nSize = m_arrINIFile.GetSize();
		
		for (int ii=0; ii<nSize; ii++)
		{
			if ((nValue = m_arrINIFile.GetAt(ii).ReadInt(lpcszSection, lpcszKey, nDefault)) >= 0)
				break;
		}
		
		return nValue;
	}
	
	BOOL WriteInt(LPCSTR lpcszSection, LPCSTR lpcszKey, int nValue)
	{
		BOOL bRet = chkCreateINIFile();
		if (bRet)
			m_arrINIFile.GetAt(USER_INI).WriteInt(lpcszSection, lpcszKey, nValue);
		
		return bRet;
	}
	
	///---Sim 03-11-2008 QA80-11240 INI_FILE_SUPPORT_READ_WRITE_DOUBLE
	double	ReadDouble(LPCSTR lpcszSection, LPCSTR lpcszKey, double dDefault = _ONAN)
	{
		double dValue = NANUM;
		int nSize = m_arrINIFile.GetSize();
		
		for (int ii=0; ii<nSize; ii++)
		{
			dValue = m_arrINIFile.GetAt(ii).ReadDouble(lpcszSection, lpcszKey, dDefault);
			if ( is_missing_value(dValue) )
				break;
		}
		
		return dValue;
	}
	BOOL	WriteDouble(LPCSTR lpcszSection, LPCSTR lpcszKey, double dValue)
	{
		BOOL bRet = chkCreateINIFile();
		if (bRet)
			m_arrINIFile.GetAt(USER_INI).WriteDouble(lpcszSection, lpcszKey, dValue);
		
		return bRet;
	}
	///---END QA80-11240 INI_FILE_SUPPORT_READ_WRITE_DOUBLE
	
	string ReadString(LPCSTR lpcszSection, LPCSTR lpcszKey, LPCSTR lpcszDefault = NULL)
	{
		string strValue;
		int nSize = m_arrINIFile.GetSize();
		
		for (int ii=0; ii<nSize; ii++)
		{
			strValue = m_arrINIFile.GetAt(ii).ReadString(lpcszSection, lpcszKey, lpcszDefault);
			if (!strValue.IsEmpty())
				break;
		}
		
		return strValue;
	}
	
	BOOL WriteString(LPCSTR lpcszSection, LPCSTR lpcszKey, LPCSTR lpcszValue)
	{
		BOOL bRet = chkCreateINIFile();
		if (bRet)
			m_arrINIFile.GetAt(USER_INI).WriteString(lpcszSection, lpcszKey, lpcszValue);
		
		return bRet;
	}
	
private:
	
	BOOL chkCreateINIFile()
	{
		string strFile = GetAppPath(false) + m_strINIFile;
		
		if (!strFile.IsFile())
		{
			file ff(strFile, file::modeCreate);
			if (!ff.IsOpen())
				return false;
			ff.Close();
			
			INIFile *pINIFile;
			pINIFile = new INIFile(m_strINIFile, true);
			if (pINIFile == NULL)
				return false;
			m_arrINIFile.SetAtGrow(0, *pINIFile);
		}
		return true;
	}
	
private:
	
	Array<INIFile&> m_arrINIFile;
	string m_strINIFile;
};

#endif		//__INIFILEEX_H__